// $Id: CPopupButton.cpp,v 1.5 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CPopupButton.hpp"
using Exponent::GUI::Controls::CPopupButton;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CPopupButton, CLatchingButton);

//	===========================================================================
CPopupButton::CPopupButton(IControlRoot *root, const long uniqueId, const CRect &area, CMenu *menu, IActionListener *listener) 
			: CLatchingButton(root, uniqueId, area, listener)
			, m_menu(NULL)
			, m_menuWindow(NULL)
			, m_windowAttributes(NULL)
			, myMenuEvent(NULL)
			, m_useIcons(true)
{
	EXPONENT_CLASS_CONSTRUCTION(CPopupButton);

	if (menu == NULL)
	{
		throw CException("Menu is NULL", "CPopupButton::CPopupButton(IControlRoot *, const long, const CRect &, CMenu *, IActionListener *)");
	}

	this->setMenu(menu);

	m_useIcons  = true;
	m_state     = false;
	m_value		= 0.0;
}

//	===========================================================================
CPopupButton::~CPopupButton()
{
	EXPONENT_CLASS_DESTRUCTION(CPopupButton);
	FORGET_COUNTED_OBJECT(m_menu);
	FREE_POINTER(m_menuWindow);
	FREE_POINTER(m_windowAttributes);
	FREE_POINTER(myMenuEvent);
}

//	===========================================================================
void CPopupButton::handleLeftButtonUp(CMouseEvent &event)
{
	if (m_cursorChange)
	{
		if (m_normalisedArea.pointIsInside(event.getMousePosition()))
		{
			event.getMutableMouse()->setCursor(&CCursor::CCURSOR_HAND);
		}
		else
		{
			event.getMutableMouse()->setCursor(&CCursor::CCURSOR_ARROW);
		}
		m_rootControl->unlockControl();
	}

	this->setValue(1.0 - m_value);
	this->update();

	if (m_state && m_menuWindow)
	{
		CPoint global;
		m_rootControl->getGlobalCoordinatesOfControl(this, global);
		m_menuWindow->openPopupWindow(global);
		#ifndef WIN32
			CWindowTools::setFocusWindow(m_menuWindow->getMutableWindowHandle());
		#endif
	}
}

//	===========================================================================
void CPopupButton::handleMenuSelection(const CMenuEvent &event)
{
	// Update the display
	this->setValue(0.0);
	this->update();
	m_rootControl->getParentWindow()->redrawWindow();

	// Create the event to let them have access
	FREE_POINTER(myMenuEvent);
	myMenuEvent = new CMenuEvent(event.getMenuItem(), event.getMenu());

	// And notify the listener
	if (m_actionListener)
	{
		m_actionListener->handleActionEvent(CActionEvent(this));
	}
}

//	===========================================================================
void CPopupButton::setMenu(CMenu *menu)
{
	EXCHANGE_COUNTED_OBJECTS(m_menu, menu);
}

//	===========================================================================
void CPopupButton::setMenuWindowAttributes(CWindowAttributes *windowAttributes, const bool useIcons)
{
	if (m_windowAttributes == NULL)
	{
		m_windowAttributes = new CWindowAttributes();//windowAttributes->getApplicationInstance());
	}

	*m_windowAttributes = *windowAttributes;
	m_useIcons			= useIcons;

	FREE_POINTER(m_menuWindow);
	m_menuWindow = new CMenuWindow(CRect(0, 0, m_area.getWidth(), 100), m_windowAttributes, m_menu, m_useIcons, this);
}

//	===========================================================================
void CPopupButton::handleMenuClosing(const CMenuEvent &event) 
{
	m_menuWindow->setCurrentSelection(-1);
	this->setValue(0.0);
	this->update();
}